/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;

public class PacketCraftingModuleTransfer {
    private List<ItemStack> inputs;
    private List<ItemStack> outputs;

    public PacketCraftingModuleTransfer(List<ItemStack> inputs, List<ItemStack> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    private PacketCraftingModuleTransfer() {
    }

    public static PacketCraftingModuleTransfer fromBytes(FriendlyByteBuf buf) {
        int i;
        PacketCraftingModuleTransfer packet = new PacketCraftingModuleTransfer();
        packet.inputs = new ArrayList<ItemStack>();
        for (i = buf.readInt(); i > 0; --i) {
            packet.inputs.add(buf.m_130267_());
        }
        packet.outputs = new ArrayList<ItemStack>();
        for (i = buf.readInt(); i > 0; --i) {
            packet.outputs.add(buf.m_130267_());
        }
        return packet;
    }

    public static void toBytes(PacketCraftingModuleTransfer packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.inputs.size());
        for (ItemStack stack : packet.inputs) {
            buf.m_130055_(stack);
        }
        buf.writeInt(packet.outputs.size());
        for (ItemStack stack : packet.outputs) {
            buf.m_130055_(stack);
        }
    }

    public static void onMessage(final PacketCraftingModuleTransfer message, final Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof CraftingModuleContainer) {
                    CraftingModuleContainer container = (CraftingModuleContainer)abstractContainerMenu;
                    PacketCraftingModuleTransfer.copy(container.input, message.inputs);
                    PacketCraftingModuleTransfer.copy(container.output, message.outputs);
                    container.modified = true;
                    container.m_38946_();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void copy(ItemStackHandler container, List<ItemStack> contents) {
        for (int i = 0; i < container.getSlots(); ++i) {
            container.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (ItemStack stack : contents) {
            ItemHandlerHelper.insertItem((IItemHandler)container, (ItemStack)stack, (boolean)false);
        }
    }
}

