/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import de.ellpeck.prettypipes.network.NetworkLocation;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class NetworkLock
implements INBTSerializable<CompoundTag> {
    private UUID lockId = UUID.randomUUID();
    public NetworkLocation location;
    public ItemStack stack;

    public NetworkLock(NetworkLocation location, ItemStack stack) {
        this.location = location;
        this.stack = stack;
    }

    public NetworkLock(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("id", this.lockId);
        nbt.m_128365_("location", (Tag)this.location.serializeNBT());
        nbt.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.lockId = nbt.m_128342_("id");
        this.location = new NetworkLocation(nbt.m_128469_("location"));
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack"));
    }

    public boolean equals(Object o) {
        if (o instanceof NetworkLock) {
            NetworkLock that = (NetworkLock)o;
            return this.lockId.equals(that.lockId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.lockId);
    }

    public String toString() {
        return "NetworkLock{location=" + this.location.pipePos + ", stack=" + this.stack + "}";
    }
}

