/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemEquality {
    public static final ItemEquality DAMAGE = new ItemEquality((stack, filter) -> stack.m_41773_() == filter.m_41773_(), false, Type.DAMAGE);
    public static final ItemEquality NBT = new ItemEquality(ItemStack::m_41658_, false, Type.NBT);
    public static final ItemEquality MOD = new ItemEquality((stack, filter) -> stack.m_41720_().getCreatorModId(stack).equals(filter.m_41720_().getCreatorModId(filter)), true, Type.MOD);
    public final Type type;
    private final BiFunction<ItemStack, ItemStack, Boolean> filter;
    private final boolean ignoreItemEquality;

    ItemEquality(BiFunction<ItemStack, ItemStack, Boolean> filter, boolean ignoreItemEquality, Type type) {
        this.filter = filter;
        this.ignoreItemEquality = ignoreItemEquality;
        this.type = type;
    }

    public static ItemEquality tag(ResourceLocation tag) {
        return new ItemEquality((stack, filter) -> stack.m_204131_().anyMatch(t -> Objects.equals(tag, t.f_203868_())), true, Type.TAG);
    }

    public static boolean compareItems(ItemStack stack, ItemStack filter, ItemEquality ... types) {
        boolean equal = ItemStack.m_41758_((ItemStack)stack, (ItemStack)filter);
        if (types.length <= 0) {
            return equal;
        }
        for (ItemEquality type : types) {
            if (!type.ignoreItemEquality && !equal) {
                return false;
            }
            if (type.filter.apply(stack, filter).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static enum Type {
        DAMAGE(() -> DAMAGE),
        NBT(() -> NBT),
        MOD(() -> MOD),
        TAG(null);

        private final Supplier<ItemEquality> defaultInstance;

        private Type(Supplier<ItemEquality> defaultInstance) {
            this.defaultInstance = defaultInstance;
        }

        public ItemEquality getDefaultInstance() {
            return this.defaultInstance.get();
        }
    }
}

