/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.ellpeck.prettypipes.network.PipeNetwork;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class Events {
    @SubscribeEvent
    public static void onWorldCaps(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("prettypipes", "network"), (ICapabilityProvider)new PipeNetwork((Level)event.getObject()));
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"prettypipes").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"dump").executes(c -> {
            CommandSourceStack source = (CommandSourceStack)c.getSource();
            Path file = Paths.get("_prettypipesdump.txt", new String[0]);
            String dump = PipeNetwork.get((Level)source.m_81372_()).toString();
            try {
                Files.writeString(file, (CharSequence)dump, StandardCharsets.UTF_8, new OpenOption[0]);
                source.m_81354_((Component)new TextComponent("Wrote network dump to file " + file.toAbsolutePath()), true);
            }
            catch (IOException e) {
                source.m_81352_((Component)new TextComponent("Failed to write network dump to file " + file.toAbsolutePath()));
                return -1;
            }
            return 0;
        }))).then(Commands.m_82127_((String)"uncache").executes(c -> {
            CommandSourceStack source = (CommandSourceStack)c.getSource();
            PipeNetwork.get((Level)source.m_81372_()).clearCaches();
            source.m_81354_((Component)new TextComponent("Cleared all pipe caches in the world"), true);
            return 0;
        }))).then(Commands.m_82127_((String)"unlock").executes(c -> {
            CommandSourceStack source = (CommandSourceStack)c.getSource();
            PipeNetwork.get((Level)source.m_81372_()).unlock();
            source.m_81354_((Component)new TextComponent("Resolved all network locks in the world"), true);
            return 0;
        })));
    }
}

