/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.entities.PipeFrameEntity;
import de.ellpeck.prettypipes.entities.PipeFrameRenderer;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.items.PipeFrameItem;
import de.ellpeck.prettypipes.items.WrenchItem;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.PipeRenderer;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.containers.MainPipeContainer;
import de.ellpeck.prettypipes.pipe.containers.MainPipeGui;
import de.ellpeck.prettypipes.pipe.modules.HighPriorityModuleItem;
import de.ellpeck.prettypipes.pipe.modules.LowPriorityModuleItem;
import de.ellpeck.prettypipes.pipe.modules.RedstoneModuleItem;
import de.ellpeck.prettypipes.pipe.modules.SortingModuleItem;
import de.ellpeck.prettypipes.pipe.modules.SpeedModuleItem;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleGui;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleItem;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleGui;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleItem;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleGui;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleItem;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleGui;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleItem;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleGui;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleGui;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleItem;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleGui;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlock;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlockEntity;
import de.ellpeck.prettypipes.pressurizer.PressurizerContainer;
import de.ellpeck.prettypipes.pressurizer.PressurizerGui;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlock;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlock;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalGui;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    public static final CreativeModeTab TAB = new CreativeModeTab("prettypipes"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)wrenchItem);
        }
    };
    public static Capability<PipeNetwork> pipeNetworkCapability = CapabilityManager.get((CapabilityToken)new CapabilityToken<PipeNetwork>(){});
    public static Capability<IPipeConnectable> pipeConnectableCapability = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPipeConnectable>(){});
    public static Item wrenchItem;
    public static Item pipeFrameItem;
    public static Block pipeBlock;
    public static BlockEntityType<PipeBlockEntity> pipeBlockEntity;
    public static MenuType<MainPipeContainer> pipeContainer;
    public static Block itemTerminalBlock;
    public static BlockEntityType<ItemTerminalBlockEntity> itemTerminalBlockEntity;
    public static MenuType<ItemTerminalContainer> itemTerminalContainer;
    public static Block craftingTerminalBlock;
    public static BlockEntityType<CraftingTerminalBlockEntity> craftingTerminalBlockEntity;
    public static MenuType<CraftingTerminalContainer> craftingTerminalContainer;
    public static EntityType<PipeFrameEntity> pipeFrameEntity;
    public static Block pressurizerBlock;
    public static BlockEntityType<PressurizerBlockEntity> pressurizerBlockEntity;
    public static MenuType<PressurizerContainer> pressurizerContainer;
    public static MenuType<ExtractionModuleContainer> extractionModuleContainer;
    public static MenuType<FilterModuleContainer> filterModuleContainer;
    public static MenuType<RetrievalModuleContainer> retrievalModuleContainer;
    public static MenuType<StackSizeModuleContainer> stackSizeModuleContainer;
    public static MenuType<FilterIncreaseModuleContainer> filterIncreaseModuleContainer;
    public static MenuType<CraftingModuleContainer> craftingModuleContainer;
    public static MenuType<FilterModifierModuleContainer> filterModifierModuleContainer;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{pipeBlock = (Block)new PipeBlock().setRegistryName("pipe"), itemTerminalBlock = (Block)new ItemTerminalBlock().setRegistryName("item_terminal"), craftingTerminalBlock = (Block)new CraftingTerminalBlock().setRegistryName("crafting_terminal"), pressurizerBlock = (Block)new PressurizerBlock().setRegistryName("pressurizer")});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        wrenchItem = (Item)new WrenchItem().setRegistryName("wrench");
        registry.registerAll((IForgeRegistryEntry[])new Item[]{wrenchItem, (Item)new Item(new Item.Properties().m_41491_(TAB)).setRegistryName("blank_module"), pipeFrameItem = (Item)new PipeFrameItem().setRegistryName("pipe_frame")});
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("extraction_module", ExtractionModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("filter_module", FilterModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("speed_module", SpeedModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("low_priority_module", LowPriorityModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("high_priority_module", HighPriorityModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("retrieval_module", RetrievalModuleItem::new));
        registry.register((IForgeRegistryEntry)new StackSizeModuleItem("stack_size_module"));
        registry.registerAll((IForgeRegistryEntry[])((Item[])Arrays.stream(ItemEquality.Type.values()).map(t -> new FilterModifierModuleItem(t.name().toLowerCase(Locale.ROOT) + "_filter_modifier", (ItemEquality.Type)((Object)t))).toArray(Item[]::new)));
        registry.register((IForgeRegistryEntry)new RedstoneModuleItem("redstone_module"));
        registry.register((IForgeRegistryEntry)new FilterIncreaseModuleItem("filter_increase_modifier"));
        registry.registerAll((IForgeRegistryEntry[])Registry.createTieredModule("crafting_module", CraftingModuleItem::new));
        registry.registerAll((IForgeRegistryEntry[])((Item[])Arrays.stream(SortingModuleItem.Type.values()).map(t -> new SortingModuleItem(t.name().toLowerCase(Locale.ROOT) + "_sorting_modifier", (SortingModuleItem.Type)((Object)t))).toArray(Item[]::new)));
        ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().m_135827_().equals("prettypipes")).forEach(b -> registry.register((IForgeRegistryEntry)((Item)new BlockItem(b, new Item.Properties().m_41491_(TAB)).setRegistryName(b.getRegistryName()))));
    }

    @SubscribeEvent
    public static void registerBlockEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new BlockEntityType[]{pipeBlockEntity = (BlockEntityType)BlockEntityType.Builder.m_155273_(PipeBlockEntity::new, (Block[])new Block[]{pipeBlock}).m_58966_(null).setRegistryName("pipe"), itemTerminalBlockEntity = (BlockEntityType)BlockEntityType.Builder.m_155273_(ItemTerminalBlockEntity::new, (Block[])new Block[]{itemTerminalBlock}).m_58966_(null).setRegistryName("item_terminal"), craftingTerminalBlockEntity = (BlockEntityType)BlockEntityType.Builder.m_155273_(CraftingTerminalBlockEntity::new, (Block[])new Block[]{craftingTerminalBlock}).m_58966_(null).setRegistryName("crafting_terminal"), pressurizerBlockEntity = (BlockEntityType)BlockEntityType.Builder.m_155273_(PressurizerBlockEntity::new, (Block[])new Block[]{pressurizerBlock}).m_58966_(null).setRegistryName("pressurizer")});
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{pipeFrameEntity = (EntityType)EntityType.Builder.m_20704_(PipeFrameEntity::new, (MobCategory)MobCategory.MISC).m_20712_("pipe_frame").setRegistryName("pipe_frame")});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        MenuType[] menuTypeArray = new MenuType[11];
        menuTypeArray[0] = pipeContainer = (MenuType)IForgeMenuType.create((windowId, inv, data) -> new MainPipeContainer(pipeContainer, windowId, inv.f_35978_, data.m_130135_())).setRegistryName("pipe");
        menuTypeArray[1] = itemTerminalContainer = (MenuType)IForgeMenuType.create((windowId, inv, data) -> new ItemTerminalContainer(itemTerminalContainer, windowId, inv.f_35978_, data.m_130135_())).setRegistryName("item_terminal");
        menuTypeArray[2] = craftingTerminalContainer = (MenuType)IForgeMenuType.create((windowId, inv, data) -> new CraftingTerminalContainer(craftingTerminalContainer, windowId, inv.f_35978_, data.m_130135_())).setRegistryName("crafting_terminal");
        menuTypeArray[3] = pressurizerContainer = (MenuType)IForgeMenuType.create((windowId, inv, data) -> new PressurizerContainer(pressurizerContainer, windowId, inv.f_35978_, data.m_130135_())).setRegistryName("pressurizer");
        extractionModuleContainer = Registry.createPipeContainer("extraction_module");
        menuTypeArray[4] = extractionModuleContainer;
        filterModuleContainer = Registry.createPipeContainer("filter_module");
        menuTypeArray[5] = filterModuleContainer;
        retrievalModuleContainer = Registry.createPipeContainer("retrieval_module");
        menuTypeArray[6] = retrievalModuleContainer;
        stackSizeModuleContainer = Registry.createPipeContainer("stack_size_module");
        menuTypeArray[7] = stackSizeModuleContainer;
        filterIncreaseModuleContainer = Registry.createPipeContainer("filter_increase_module");
        menuTypeArray[8] = filterIncreaseModuleContainer;
        craftingModuleContainer = Registry.createPipeContainer("crafting_module");
        menuTypeArray[9] = craftingModuleContainer;
        filterModifierModuleContainer = Registry.createPipeContainer("filter_modifier_module");
        menuTypeArray[10] = filterModifierModuleContainer;
        event.getRegistry().registerAll((IForgeRegistryEntry[])menuTypeArray);
    }

    private static <T extends AbstractPipeContainer<?>> MenuType<T> createPipeContainer(String name) {
        return (MenuType)IForgeMenuType.create((windowId, inv, data) -> {
            PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)inv.f_35978_.f_19853_, data.m_130135_());
            int moduleIndex = data.readInt();
            ItemStack moduleStack = tile.modules.getStackInSlot(moduleIndex);
            return ((IModule)moduleStack.m_41720_()).getContainer(moduleStack, tile, windowId, inv, inv.f_35978_, moduleIndex);
        }).setRegistryName(name);
    }

    private static Item[] createTieredModule(String name, BiFunction<String, ModuleTier, ModuleItem> item) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ModuleTier tier : ModuleTier.values()) {
            items.add((Item)item.apply(name, tier).setRegistryName(tier.name().toLowerCase(Locale.ROOT) + "_" + name));
        }
        return items.toArray(new Item[0]);
    }

    public static void setup(FMLCommonSetupEvent event) {
        PacketHandler.setup();
    }

    public static final class Client {
        public static void setup(FMLClientSetupEvent event) {
            ItemBlockRenderTypes.setRenderLayer((Block)pipeBlock, (RenderType)RenderType.m_110463_());
            BlockEntityRenderers.m_173590_(pipeBlockEntity, PipeRenderer::new);
            EntityRenderers.m_174036_(pipeFrameEntity, PipeFrameRenderer::new);
            MenuScreens.m_96206_(pipeContainer, MainPipeGui::new);
            MenuScreens.m_96206_(itemTerminalContainer, ItemTerminalGui::new);
            MenuScreens.m_96206_(pressurizerContainer, PressurizerGui::new);
            MenuScreens.m_96206_(craftingTerminalContainer, CraftingTerminalGui::new);
            MenuScreens.m_96206_(extractionModuleContainer, ExtractionModuleGui::new);
            MenuScreens.m_96206_(filterModuleContainer, FilterModuleGui::new);
            MenuScreens.m_96206_(retrievalModuleContainer, RetrievalModuleGui::new);
            MenuScreens.m_96206_(stackSizeModuleContainer, StackSizeModuleGui::new);
            MenuScreens.m_96206_(filterIncreaseModuleContainer, FilterIncreaseModuleGui::new);
            MenuScreens.m_96206_(craftingModuleContainer, CraftingModuleGui::new);
            MenuScreens.m_96206_(filterModifierModuleContainer, FilterModifierModuleGui::new);
        }
    }
}

