/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RenderUtils {
    private static final RenderType LINES = RenderType.m_173215_((String)"supermartijn642corelib:lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)128, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderTypeExtension.getLinesState());
    private static final RenderType LINES_NO_DEPTH = RenderType.m_173215_((String)"supermartijn642corelib:lines_no_depth", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)128, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderTypeExtension.getLinesStateNoDepth());
    public static final RenderType QUADS = RenderType.m_173215_((String)"supermartijn642corelib:quads", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderTypeExtension.getQuadState());
    public static final RenderType QUADS_NO_DEPTH = RenderType.m_173215_((String)"supermartijn642corelib:quads_no_depth", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderTypeExtension.getQuadStateNoDepth());
    private static boolean depthTest = true;

    public static void enableDepthTest() {
        depthTest = true;
    }

    public static void disableDepthTest() {
        depthTest = false;
    }

    public static void resetState() {
        depthTest = true;
    }

    public static Vec3 getCameraPosition() {
        return ClientUtils.getMinecraft().m_91290_().f_114358_.m_90583_();
    }

    public static MultiBufferSource.BufferSource getMainBufferSource() {
        return ClientUtils.getMinecraft().m_91269_().m_110104_();
    }

    public static void renderShape(PoseStack poseStack, BlockShape shape, float red, float green, float blue, float alpha) {
        VertexConsumer builder = RenderUtils.getMainBufferSource().m_6299_(depthTest ? LINES : LINES_NO_DEPTH);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            Vec3 normal = new Vec3(x2 - x1, y2 - y1, z2 - z1);
            normal.m_82541_();
            builder.m_85982_(matrix4f, (float)x1, (float)y1, (float)z1).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
            builder.m_85982_(matrix4f, (float)x2, (float)y2, (float)z2).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        });
        RenderUtils.getMainBufferSource().m_109912_(depthTest ? LINES : LINES_NO_DEPTH);
    }

    public static void renderShapeSides(PoseStack poseStack, BlockShape shape, float red, float green, float blue, float alpha) {
        VertexConsumer builder = RenderUtils.getMainBufferSource().m_6299_(depthTest ? QUADS : QUADS_NO_DEPTH);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        shape.forEachBox(box -> {
            float minX = (float)box.f_82288_;
            float maxX = (float)box.f_82291_;
            float minY = (float)box.f_82289_;
            float maxY = (float)box.f_82292_;
            float minZ = (float)box.f_82290_;
            float maxZ = (float)box.f_82293_;
            builder.m_85982_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_85982_(matrix, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_5752_();
        });
        RenderUtils.getMainBufferSource().m_109912_(depthTest ? QUADS : QUADS_NO_DEPTH);
    }

    public static void renderShape(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, alpha);
    }

    public static void renderShapeSides(PoseStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, alpha);
    }

    public static void renderBox(PoseStack poseStack, AABB box, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, alpha);
    }

    public static void renderBoxSides(PoseStack poseStack, AABB box, float red, float green, float blue, float alpha) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, alpha);
    }

    public static void renderShape(PoseStack poseStack, BlockShape shape, float red, float green, float blue) {
        RenderUtils.renderShape(poseStack, shape, red, green, blue, 1.0f);
    }

    public static void renderShapeSides(PoseStack poseStack, BlockShape shape, float red, float green, float blue) {
        RenderUtils.renderShapeSides(poseStack, shape, red, green, blue, 1.0f);
    }

    public static void renderShape(PoseStack poseStack, VoxelShape shape, float red, float green, float blue) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, 1.0f);
    }

    public static void renderShapeSides(PoseStack poseStack, VoxelShape shape, float red, float green, float blue) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, 1.0f);
    }

    public static void renderBox(PoseStack poseStack, AABB box, float red, float green, float blue) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, 1.0f);
    }

    public static void renderBoxSides(PoseStack poseStack, AABB box, float red, float green, float blue) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, 1.0f);
    }

    private static class RenderTypeExtension
    extends RenderType {
        private static final RenderStateShard.DepthTestStateShard NO_DEPTH_TEST = new RenderStateShard.DepthTestStateShard("always", 519){

            public void m_110185_() {
                RenderSystem.m_69465_();
                super.m_110185_();
            }
        };

        public RenderTypeExtension(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        public static RenderType.CompositeState getLinesState() {
            return RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(f_110130_).m_110685_(f_110139_).m_110669_(f_110119_).m_110661_(f_110110_).m_110663_(f_110113_).m_110687_(f_110115_).m_110691_(false);
        }

        public static RenderType.CompositeState getLinesStateNoDepth() {
            return RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(f_110130_).m_110685_(f_110139_).m_110669_(f_110119_).m_110661_(f_110110_).m_110663_(NO_DEPTH_TEST).m_110687_(f_110115_).m_110691_(false);
        }

        public static RenderType.CompositeState getQuadState() {
            return RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110685_(f_110139_).m_173290_(f_110147_).m_110661_(f_110110_).m_110663_(f_110113_).m_110687_(f_110115_).m_110691_(false);
        }

        public static RenderType.CompositeState getQuadStateNoDepth() {
            return RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110685_(f_110139_).m_173290_(f_110147_).m_110661_(f_110110_).m_110663_(NO_DEPTH_TEST).m_110687_(f_110115_).m_110691_(false);
        }
    }
}

