#define WAVING_CROPS
#define WAVING_FIRE
#define WAVING_GRASS
#define WAVING_LAVA
#define WAVING_LEAVES
#define WAVING_LILYPAD
#define WAVING_TALL_PLANT
#define WAVING_PLANT
#define WAVING_VINES

const float pi = 3.1415927;
float pi2wt = 6.2831854 * (frametime * 24.0);

vec3 CalcWave(vec3 pos, float fm, float mm, float ma, float f0, float f1, float f2, float f3, float f4, float f5) {
    vec3 ret;
    float magnitude, d0, d1, d2, d3;
    magnitude = sin(pi2wt * fm + pos.x*0.5 + pos.z*0.5 + pos.y*0.5) * mm + ma;
    d0 = sin(pi2wt * f0);
    d1 = sin(pi2wt * f1);
    d2 = sin(pi2wt * f2);
    ret.x = sin(pi2wt*f3 + d0 + d1 - pos.x + pos.z + pos.y) * magnitude;
    ret.z = sin(pi2wt*f4 + d1 + d2 + pos.x - pos.z + pos.y) * magnitude;
    ret.y = sin(pi2wt*f5 + d2 + d0 + pos.z + pos.y - pos.y) * magnitude;
    return ret;
}

vec3 CalcMove(in vec3 pos, float f0, float f1, float f2, float f3, float f4, float f5, vec3 amp1, vec3 amp2) {
    vec3 move1 = CalcWave(pos      , 0.0027, 0.0400, 0.0400, 0.0127, 0.0089, 0.0114, 0.0063, 0.0224, 0.0015) * amp1;
    vec3 move2 = CalcWave(pos+move1, 0.0348, 0.0400, 0.0400, f0, f1, f2, f3, f4, f5) * amp2;
    return move1 + move2;
}

float CalcLilypadMove(vec3 worldpos){
    float wave = sin(2 * pi * (frametime*0.7 + worldpos.x * 0.14 + worldpos.z * 0.07))
                + sin(2 * pi * (frametime*0.5 + worldpos.x * 0.10 + worldpos.z * 0.20));
    return wave * 0.025;
}

float CalcLavaMove(vec3 worldpos){
    float fy = fract(worldpos.y + 0.005);
		
    if (fy > 0.01){
    float wave = sin(2 * pi * (frametime*0.7 + worldpos.x * 0.14 + worldpos.z * 0.07)) +
                 sin(2 * pi * (frametime*0.5 + worldpos.x * 0.10 + worldpos.z * 0.20));
    return wave * 0.025;
    } else return 0.0;
}

vec3 CalcLanternMove(vec3 position){
    vec3 frc = fract(position);
    frc = vec3(frc.x - 0.5, fract(frc.y - 0.001) - 1.0, frc.z - 0.5);
    vec3 flr = position - frc;
    float offset = flr.x * 2.4 + flr.y * 2.7 + flr.z * 2.2;

    float rx = sin(frametime       + offset) * pi * 0.027;
    float ry = sin(frametime * 1.7 + offset) * pi * 0.027;
    float rz = sin(frametime * 1.4 + offset) * pi * 0.027;
    mat3 rotx = mat3(
               1,        0,        0,
               0,  cos(rx), -sin(rx),
               0,  sin(rx),  cos(rx)
    );
    mat3 roty = mat3(
         cos(ry),        0,  sin(ry),
               0,        1,        0,
        -sin(ry),        0,  cos(ry)
    );
    mat3 rotz = mat3(
         cos(rz), -sin(rz),        0,
         sin(rz),  cos(rz),        0,
               0,        0,        1
    );
    frc = rotx * roty * rotz * frc;
    
    return flr + frc - position;
}

vec3 WavingBlocks(vec3 position, float istopv){
    vec3 wave = vec3(0.0);
    vec3 worldpos = position + cameraPosition;

    #ifdef WAVING_CROPS
    if ((mc_Entity.x == 102 || mc_Entity.x == 108) && (istopv > 0.9 || fract(worldpos.y + 0.0675) > 0.01))
        wave += CalcMove(worldpos, 0.0041, 0.0070, 0.0044, 0.0038, 0.0240, 0.0000, vec3(0.4,0.0,0.4), vec3(0.2,0.0,0.2));
    #endif
    #ifdef WAVING_FIRE
    if (mc_Entity.x == 51 && istopv > 0.9)
        wave += CalcMove(worldpos, 0.0105, 0.0096, 0.0167, 0.0063, 0.0097, 0.0156, vec3(1.2,0.4,1.2), vec3(0.8,0.8,0.8));
    #endif
    #ifdef WAVING_GRASS
    if (mc_Entity.x == 100 && istopv > 0.9)
        wave += CalcMove(worldpos, 0.0041, 0.0070, 0.0044, 0.0038, 0.0063, 0.0000, vec3(0.8,0.0,0.8), vec3(0.4,0.0,0.4));
    #endif
    #ifdef WAVING_LAVA
    if (mc_Entity.x == 10)
        wave.y += CalcLavaMove(worldpos);
    #endif
    #ifdef WAVING_LEAVES
    if (mc_Entity.x == 105)
        wave += CalcMove(worldpos, 0.0040, 0.0064, 0.0043, 0.0035, 0.0037, 0.0041, vec3(0.5,0.5,0.5), vec3(0.25,0.25,0.25));
    #endif
    #ifdef WAVING_LILYPAD
    if (mc_Entity.x == 107)
        wave.y += CalcLilypadMove(worldpos);
    #endif
    #ifdef WAVING_TALL_PLANT
    if (mc_Entity.x == 103 || (mc_Entity.x == 104.0 && (istopv > 0.9 || fract(worldpos.y+0.005)>0.01)))
        wave += CalcMove(worldpos, 0.0041, 0.005, 0.0044, 0.0038, 0.0240, 0.0000, vec3(0.8,0.1,0.8), vec3(0.4,0.0,0.4));
    #endif
    #ifdef WAVING_PLANT
    if (mc_Entity.x == 101 && (istopv > 0.9 || fract(worldpos.y + 0.005) > 0.01))
        wave += CalcMove(worldpos, 0.0041, 0.005, 0.0044, 0.0038, 0.0240, 0.0000, vec3(0.6,0.0,0.6), vec3(0.3,0.0,0.3));
    #endif
    #ifdef WAVING_VINES
    if (mc_Entity.x == 106)
        wave += CalcMove(worldpos, 0.0080, 0.0064, 0.0043, 0.0070, 0.0037, 0.0041, vec3(0.15,0.2,0.15), vec3(0.15,0.1,0.15));
    #endif
    #ifdef WAVING_LANTERN
    if(mc_Entity.x == 251 || mc_Entity.x == 253)
		wave += CalcLanternMove(worldpos);
    #endif

    position += wave;

    return position;
}